package w83b.w83bOperacionesPaso.w83bCierre;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCierreMensualBean;
import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bCrearExcelCierremensualAction extends Q70ActionPasoOP{

	int j=0;//NOPMD
	int contador=0;//NOPMD
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bCierremensual.xls";
		InputStream inputStream = W83bCrearExcelCierremensualAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List calculofila2 = (ArrayList)((Map)contexto.get("w83bMapaCierreBean")).get("calculofila2");
        List bajas = (ArrayList)((Map)contexto.get("w83bMapaCierreBean")).get("bajas");
        Map calculofila3 = (HashMap)((Map)contexto.get("w83bMapaCierreBean")).get("listaexcel");
        List calculofila4 = (ArrayList)((Map)contexto.get("w83bMapaCierreBean")).get("calculofila4");
        W83bCierreMensualBean cierreBean = (W83bCierreMensualBean)contexto.get("w83bCierreMensualResultadoBean");
        HashMap excelnuevas = (HashMap)((Map)contexto.get("w83bMapaCierreBean")).get("excelnuevas");
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;

        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)6);
        
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
       
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)6);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cierreMensual",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cierreMensual",W83bClsConstantes.CONSTANTE_CASTELLANO));
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)5); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cierreMensual",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.cierreMensual",W83bClsConstantes.CONSTANTE_CASTELLANO));
        
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)2);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(cierreBean.getDescTerritorio())){
        	cell.setCellValue(cierreBean.getDescTerritorio().toUpperCase());
        }
        cell = row.getCell((short)6);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.certificaciones.fechaEleccionDesde",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)7); 
        if(StringUtils.isNotEmpty(cierreBean.getFechaelecciondesde())){
        	cell.setCellValue(cierreBean.getFechaelecciondesde());
        }
        cell = row.getCell((short)12); 
        sheet.addMergedRegion(new Region((short)11,(short)12,(short)11,(short)16));//NOPMD
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fechaRegDefinitivoHasta",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.fechaRegDefinitivoHasta",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)17);
        if(StringUtils.isNotEmpty(cierreBean.getFecharegistrohasta())){
        	cell.setCellValue(cierreBean.getFecharegistrohasta());
        }
        
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)2); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.annocerrado",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.annocerrado",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(cierreBean.getAnocierre())){
        	cell.setCellValue(cierreBean.getAnocierre());
        }
        cell = row.getCell((short)6);  
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.mescerrado",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.mescerrado",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)7); 
        cell.setCellValue(W83bDateUtil.getInstance().sabernombremes(Integer.parseInt(cierreBean.getMes())-1,idioma).toUpperCase());     
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)2); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)3); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.felec",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.felec",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)4);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.nif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.nif",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)5);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)8);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)9);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ela",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)10);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ccoo",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)11);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ugt",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)12);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.lab",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)14);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.uso",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)15);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cuis",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)16);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cti",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)17);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.csicsi",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)18);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.nosin",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)19);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        cell = row.getCell((short)20);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.registroDefinitivo.numEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)2); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nRegistro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)3); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.felec",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.felec",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)4);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.nif",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.nif",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)5);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)8);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell((short)9);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ela",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)10);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ccoo",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)11);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.ugt",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)12);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.lab",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)14);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.uso",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)15);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cuis",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)16);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cti",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)17);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.csicsi",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)18);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.nosin",W83bClsConstantes.CONSTANTE_EUSKARA));
        cell = row.getCell((short)19);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        cell = row.getCell((short)20);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.total",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
        j=16;
        contador=0;
        pintarfila2(null,calculofila2,sheet,excel,"fila2",idioma);
        
        j=j+2;
        pintarfila2(null,bajas,sheet,excel,"bajas",idioma);
        
        j=j+2;
        pintarfila3(calculofila3,sheet,excel,"fila3",idioma);
        
        j=j+2;
        pintarfila2(excelnuevas,calculofila4,sheet,excel,"fila4",idioma);
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoCierreMensual.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
			return excel.styleTextoPar;
	}
	
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		return excel.styleTextoParNumero;
	}
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		return excel.styleTextoParNumeroCentrado;
		
	}
	
	/**
	 * @param calculofila
	 * @param sheet
	 * @param excel
	 * @param fila
	 * @param idioma
	 * @throws Q70GestorMensajesException
	 */
	public void pintarfila2(HashMap excelnuevas,List calculofila,HSSFSheet sheet, W83bUtilidadesExcel excel,String fila,String idioma) throws Q70GestorMensajesException{
		String acta="";
		String territ="";
		int anoacta=0;
		int ver=0;
	    int otros=0;
	    int total=0;
	    HSSFRow row=sheet.createRow((short)j+contador);
	    HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        W83bClsTrazas.trazaError(null, "calculofila.size(): "+calculofila.size() ,null);
		for(int i=0;i<calculofila.size();i++){
			String numdelegados=((W83bResultadosBean)calculofila.get(i)).getNumdelegados();
        	if (!acta.equals(((W83bResultadosBean)calculofila.get(i)).getNacta())||!territ.equals(((W83bResultadosBean)calculofila.get(i)).getTerritorio())||anoacta!=Integer.parseInt(((W83bResultadosBean)calculofila.get(i)).getAnoacta())||ver!=Integer.parseInt(((W83bResultadosBean)calculofila.get(i)).getVer())){
        		if (i==0){
        			if ("fila2".equals(fila)){
        				cell = row.createCell((short)0);
            			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.caen",idioma,null).toUpperCase());
        			}
        			else if ("bajas".equals(fila)){
        				cell = row.createCell((short)0);
            			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.bajas",idioma,null).toUpperCase());
        			}else{
        				cell = row.createCell((short)0);
            			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.nuev",idioma,null).toUpperCase());
        			}
        			
        		}
        		else if (i>0){
        			cell = row.createCell((short)20); 
        			if (total==0){
        				cell.setCellValue(0);
        			}
        			else{
        				cell.setCellValue(total);
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}
        		otros=0;
        		total=0;
        		
        		row = sheet.createRow((short)j+contador); // Creacin de la fila 1
            	cell = row.createCell((short)1); 
            	StringBuffer sb=new StringBuffer();//NOPMD
            	String valor=W83bUtilidadesComunes.rellenarCeros(((W83bResultadosBean)calculofila.get(i)).getNacta());
            	sb.append(valor);
            	cell.setCellValue(((W83bResultadosBean)calculofila.get(i)).getTerritorio()+"/"+((W83bResultadosBean)calculofila.get(i)).getAnoacta()+"/"+sb.toString());
            	cell.setCellStyle(estiloFilaCentro(contador,excel));
            	cell = row.createCell((short)2); 
            	sb=new StringBuffer();//NOPMD
            	if (((W83bResultadosBean)calculofila.get(i)).getNregdef()!=null){
            		valor=W83bUtilidadesComunes.rellenarCeros(((W83bResultadosBean)calculofila.get(i)).getNregdef());
            		sb.append(valor);
                	cell.setCellValue(((W83bResultadosBean)calculofila.get(i)).getTerritorio()+"/"+((W83bResultadosBean)calculofila.get(i)).getAnoregdef()+"/"+sb.toString());
            	}
            	cell.setCellStyle(estiloFilaCentro(contador,excel));
            	
            	cell = row.createCell((short)3); 
            	if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getFelec())){
            		cell.setCellValue(((W83bResultadosBean)calculofila.get(i)).getFelec());
            	}
            	cell.setCellStyle(estiloFilaCentro(contador,excel));
            	
            	cell = row.createCell((short)4); 
            	if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getCif())){
            		cell.setCellValue(((W83bResultadosBean)calculofila.get(i)).getCif());
            	}
            	cell.setCellStyle(estiloFilaCentro(contador,excel));
            	
            	cell = row.createCell((short)5);
            	cell3 = row.createCell((short)7);
            	cell2 = row.createCell((short)6); 
            	sheet.addMergedRegion(new Region(j+contador,(short)5,j+contador,(short)7));//NOPMD
            	if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getRazon())){
            		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bResultadosBean)calculofila.get(i)).getRazon()));
            	}
            	cell.setCellStyle(estiloFila(contador,excel));            	
            	cell3.setCellStyle(estiloFila(contador,excel));
            	cell2.setCellStyle(estiloFila(contador,excel));
            	
            	cell = row.createCell((short)8); 
            	if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNcentro())){
            		cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNcentro()));
            	}
            	cell.setCellStyle(estiloFilaCentro(contador,excel));
            	
            	cell = row.createCell((short)9);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)10);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)11);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)12);
            	cell2 = row.createCell((short)13);
            	sheet.addMergedRegion(new Region(j+contador,(short)12,j+contador,(short)13));//NOPMD
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	cell2.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)14);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)15);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)16);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)17);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)18);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	
            	cell = row.createCell((short)19);
            	cell.setCellStyle(estiloFilaNumero(contador,excel));
            	if (W83bClsConstantes.codELA.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//ELA
        			cell = row.createCell((short)9); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codCCOO.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//CCOO
        			cell = row.createCell((short)10); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codUGT.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//UGT
        			cell = row.createCell((short)11); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codLAB.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//LAB
        			cell = row.createCell((short)12); 
        			cell2 = row.createCell((short)13); 
        			sheet.addMergedRegion(new Region(j+contador,(short)12,j+contador,(short)13));//NOPMD
        			
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
                	cell2.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codUSO.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//USO
        			cell = row.createCell((short)14); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codCUIS.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//CUIS
        			cell = row.createCell((short)15); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codCTI.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//CTI
        			cell = row.createCell((short)16); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codCSI.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//CSI/CSI
        			cell = row.createCell((short)17); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else if (W83bClsConstantes.codNOSIN.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			//NO SIN
        			cell = row.createCell((short)18); 
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(((W83bResultadosBean)calculofila.get(i)).getNumdelegados()));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}else{
        			//OTROS
        			cell = row.createCell((short)19); 
        			otros=otros+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if (otros==0){
        				cell.setCellValue(0);
        			}
        			else{
        				cell.setCellValue(otros);
        			}
                	cell.setCellStyle(estiloFilaNumero(contador,excel));
        		}
            	
            	acta=((W83bResultadosBean)calculofila.get(i)).getNacta();
				territ=((W83bResultadosBean)calculofila.get(i)).getTerritorio();
				anoacta=Integer.parseInt(((W83bResultadosBean)calculofila.get(i)).getAnoacta());
				ver=Integer.parseInt(((W83bResultadosBean)calculofila.get(i)).getVer());
            	contador=contador+1;
            	W83bCierreMensualBean cm = new W83bCierreMensualBean();//NOPMD
            	if (excelnuevas!=null){
            		W83bClsTrazas.trazaError(null, "excelnuevas distinto de null "+excelnuevas.size() ,null);
            		Iterator it = excelnuevas.entrySet().iterator();
            		while (it.hasNext()) {
            		Map.Entry e = (Map.Entry)it.next();
            		W83bClsTrazas.trazaError(null, "e.getKey()= "+e.getKey() + " " + e.getValue() ,null);
            		}
            	}
            	if (!"fila2".equals(fila)&&!"bajas".equals(fila)){
            		W83bClsTrazas.trazaError(null, "buscando acta: "+((W83bResultadosBean)calculofila.get(i)).getTerritorio()+"|"+((W83bResultadosBean)calculofila.get(i)).getAnoacta()+"|"+((W83bResultadosBean)calculofila.get(i)).getNacta() ,null);
            		cm=(W83bCierreMensualBean)excelnuevas.get(((W83bResultadosBean)calculofila.get(i)).getTerritorio()+"|"+((W83bResultadosBean)calculofila.get(i)).getAnoacta()+"|"+((W83bResultadosBean)calculofila.get(i)).getNacta());
            		W83bClsTrazas.trazaError(null, "cm: "+cm ,null);
            		if (cm!=null){
            			W83bClsTrazas.trazaError(null, "excel entrado: cm distinto de null" ,null);
            			int numero=0;
            			W83bClsTrazas.trazaError(null, "cm.getEla(): "+cm.getEla() ,null);
            			
            			
                		if (cm.getEla()!=0){
                			if(null==row.getCell((short)9)){
                				cell = row.createCell((short)9);
                				numero=(int)cm.getEla();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getEla();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)9); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getEla();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getEla();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getCcoo(): "+cm.getCcoo() ,null);
                		if (cm.getCcoo()!=0){
                			if(null==row.getCell((short)10)){
                				W83bClsTrazas.trazaError(null, "entrado en null: "+(int)cm.getCcoo() ,null);
                				cell = row.createCell((short)10);
                				numero=(int)cm.getCcoo();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getCcoo();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
                				W83bClsTrazas.trazaError(null, "no entrado en null: "+(int)cm.getCcoo()+(int)cell.getNumericCellValue()+cm.getCcoo() ,null);
    	            			cell = row.getCell((short)10); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getCcoo();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getCcoo();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getUgt(): "+cm.getUgt() ,null);
                		if (cm.getUgt()!=0){
                			W83bClsTrazas.trazaError(null, "ugt: " ,null);
                			if(null==row.getCell((short)11)){
                				cell = row.createCell((short)11);
                				numero=(int)cm.getUgt();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getUgt();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)11); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getUgt();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getUgt();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getLab(): "+cm.getLab() ,null);
                		if (cm.getLab()!=0){
                			W83bClsTrazas.trazaError(null, "lab: " ,null);
                			if(null==row.getCell((short)12)){
                				cell = row.createCell((short)12);
                				numero=(int)cm.getLab();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getLab();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)12); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getLab();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getLab();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getUso(): "+cm.getUso() ,null);
                		if (cm.getUso()!=0){
                			W83bClsTrazas.trazaError(null, "uso: " ,null);
                			if(null==row.getCell((short)14)){
                				cell = row.createCell((short)14);
                				numero=(int)cm.getUso();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getUso();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)14); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getUso();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getUso();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getCuis(): "+cm.getCuis() ,null);
                		if (cm.getCuis()!=0){
                			W83bClsTrazas.trazaError(null, "cuis: " ,null);
                			if(null==row.getCell((short)15)){
                				cell = row.createCell((short)15);
                				numero=(int)cm.getCuis();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getCuis();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)15); 
    	            			W83bClsTrazas.trazaError(null, "(int)cell.getNumericCellValue(): "+(int)cell.getNumericCellValue() ,null);
    	            			numero=(int)cell.getNumericCellValue()+cm.getCuis();
    	            			W83bClsTrazas.trazaError(null, "numero: "+numero ,null);
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getCuis();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getCti(): "+cm.getCti() ,null);
                		if (cm.getCti()!=0){
                			W83bClsTrazas.trazaError(null, "cti: " ,null);
                			if(null==row.getCell((short)16)){
                				cell = row.createCell((short)16);
                				numero=(int)cm.getCti();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getCti();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)16); 
    	            			W83bClsTrazas.trazaError(null, "(int)cell.getNumericCellValue(): "+(int)cell.getNumericCellValue() ,null);
    	            			numero=(int)cell.getNumericCellValue()+cm.getCti();
    	            			W83bClsTrazas.trazaError(null, "numero: "+numero ,null);
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getCti();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getCsi(): "+cm.getCsi() ,null);
                		if (cm.getCsi()!=0){
                			W83bClsTrazas.trazaError(null, "csi: " ,null);
                			if(null==row.getCell((short)17)){
                				cell = row.createCell((short)17);
                				numero=(int)cm.getCsi();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getCsi();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)17); 
    	            			W83bClsTrazas.trazaError(null, "(int)cell.getNumericCellValue(): "+(int)cell.getNumericCellValue() ,null);
    	            			numero=(int)cell.getNumericCellValue()+cm.getCsi();
    	            			W83bClsTrazas.trazaError(null, "numero: "+numero ,null);
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getCsi();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getNosin(): "+cm.getNosin() ,null);
                		if (cm.getNosin()!=0){
                			W83bClsTrazas.trazaError(null, "nosin: " ,null);
                			if(null==row.getCell((short)18)){
                				cell = row.createCell((short)18);
                				numero=(int)cm.getNosin();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getNosin();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)18); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getNosin();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getNosin();
                			}
                		}
                		W83bClsTrazas.trazaError(null, "cm.getOtros(): "+cm.getOtros() ,null);
                		if (cm.getOtros()!=0){
                			W83bClsTrazas.trazaError(null, "otros: " ,null);
                			if(null==row.getCell((short)19)){
                				cell = row.createCell((short)19);
                				numero=(int)cm.getOtros();
                				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
                				total=total+cm.getOtros();
                				cell.setCellStyle(estiloFilaNumero(contador,excel));
                			}else{
    	            			cell = row.getCell((short)19); 
    	            			numero=(int)cell.getNumericCellValue()+cm.getOtros();
    	            			cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
    	            			total=total+cm.getOtros();
                			}
                		}
                		
            		}
            		}
        			
        	}
        	else{
        		int numero=0;
        		if (W83bClsConstantes.codELA.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "ela2: " ,null);
        			//ELA
        			if (row.getCell((short)9)==null){
        				cell = row.createCell((short)9); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)9); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCCOO.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "ccoo2: " ,null);
        			W83bClsTrazas.trazaError(null, "ccoo2: "+row.getCell((short)10) ,null);
        			//CCOO
        			if (row.getCell((short)10)==null){
        				cell = row.createCell((short)10); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)10); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			W83bClsTrazas.trazaError(null, "ccoo2: "+numero ,null);
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codUGT.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "ugt2: " ,null);
        			//UGT
        			if (row.getCell((short)11)==null){
        				cell = row.createCell((short)11); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)11); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codLAB.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "lab2: " ,null);
        			//LAB
        			if (row.getCell((short)12)==null){
        				cell = row.createCell((short)12); 
            			sheet.addMergedRegion(new Region(j+contador,(short)12,j+contador,(short)13)); //NOPMD
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)12); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codUSO.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "uso2: " ,null);
        			//USO
        			if (row.getCell((short)14)==null){
        				cell = row.createCell((short)14); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)14); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCUIS.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "cuis2: " ,null);
        			//CUIS
        			if (row.getCell((short)15)==null){
        				cell = row.createCell((short)15); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)15); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCTI.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "cti2: " ,null);
        			//CTI
        			if (row.getCell((short)16)==null){
        				cell = row.createCell((short)16); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)16); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codCSI.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "csi2: " ,null);
        			//CSI/CSI
        			if (row.getCell((short)17)==null){
        				cell = row.createCell((short)17); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)17); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else if (W83bClsConstantes.codNOSIN.equals(((W83bResultadosBean)calculofila.get(i)).getCodsindicato())){
        			W83bClsTrazas.trazaError(null, "nosin2: " ,null);
        			//NO SIN
        			if (row.getCell((short)18)==null){
        				cell = row.createCell((short)18); 
            			numero=Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			else{
        				cell = row.getCell((short)18); 
            			numero=(int)cell.getNumericCellValue()+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			}
        			total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
        			if(StringUtils.isNotEmpty(((W83bResultadosBean)calculofila.get(i)).getNumdelegados())){
        				cell.setCellValue(W83bUtilidades.numero(String.valueOf(numero)));
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}else{
        			W83bClsTrazas.trazaError(null, "otros2: " ,null);
        			//OTROS
        			if (row.getCell((short)19)==null){
        				cell = row.createCell((short)19); 
        				if (((W83bResultadosBean)calculofila.get(i)).getNumdelegados()!=null){
            				otros=otros+Integer.parseInt(numdelegados==null?"0":numdelegados);
            			}
            			else{
            				otros=otros+0;
            			}
            			if (((W83bResultadosBean)calculofila.get(i)).getNumdelegados()!=null){
            				total=total+Integer.parseInt(numdelegados==null?"0":numdelegados);
            			}
            			else{
            				total=total+0;
            			}
        			}
        			else{
        				cell = row.getCell((short)19); 
        				if (((W83bResultadosBean)calculofila.get(i)).getNumdelegados()!=null){
            				otros=otros+Integer.parseInt(numdelegados==null?"0":numdelegados)+(int)cell.getNumericCellValue();
            			}
            			else{
            				otros=otros+0+(int)cell.getNumericCellValue();
            			}
            			if (((W83bResultadosBean)calculofila.get(i)).getNumdelegados()!=null){
            				total=total+Integer.parseInt(numdelegados==null?"0":numdelegados)+(int)cell.getNumericCellValue();
            			}
            			else{
            				total=total+0+(int)cell.getNumericCellValue();
            			}
        			}
        			
        			
        			if (otros==0){
        				cell.setCellValue(0);
        			}
        			else{
        				cell.setCellValue(otros);
        			}
                	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        		}
        		
        		
        	}
        	if (i==calculofila.size()-1){
        		cell = row.createCell((short)20); 
        		if (total==0){
        			cell.setCellValue(0);
        		}
        		else{
        			cell.setCellValue(total);
        		}
            	cell.setCellStyle(estiloFilaNumero(contador-1,excel));
        	}
        	
        }
	}
	
	public void pintarfila3(Map calculofila,HSSFSheet sheet, W83bUtilidadesExcel excel,String fila,String idioma) throws Q70GestorMensajesException{
	    HSSFRow row=sheet.createRow((short)j+contador);
	    HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
        Map mapActasOrdenado = new TreeMap(calculofila);
        Set ref = mapActasOrdenado.keySet();
        int i=0;
        for( Iterator it = ref.iterator(); it.hasNext();) {
        	String a=(String)it.next();
        	row = sheet.createRow((short)j+contador); // Creacin de la fila 1
        	if (i==0){
    			cell = row.createCell((short)0);
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.cierre.inc",idioma,null).toUpperCase());
    			
    		}
        	cell = row.createCell((short)1); 
        	StringBuffer sb=new StringBuffer();//NOPMD
        	cell.setCellValue(a.substring(0,2)+"/"+a.substring(2,6)+"/"+a.substring(6,a.length()));
        	cell.setCellStyle(estiloFilaCentro(contador,excel));
        	
        	List sindicatos=(ArrayList)mapActasOrdenado.get(a);
        	cell = row.createCell((short)2); 
        	sb=new StringBuffer();//NOPMD
        	String valor=W83bUtilidadesComunes.rellenarCeros(((String)sindicatos.get(0)));
        	sb.append(valor);
        	cell.setCellValue(a.substring(2,6)+"/"+((String)sindicatos.get(1))+"/"+sb.toString());
        	cell.setCellStyle(estiloFilaCentro(contador,excel));
        	
        	cell = row.createCell((short)3); 
        	if(StringUtils.isNotEmpty(((String)sindicatos.get(2)))){
        		cell.setCellValue(((String)sindicatos.get(2)));
			}
        	
        	cell.setCellStyle(estiloFilaCentro(contador,excel));
        	
        	cell = row.createCell((short)4); 
        	if(StringUtils.isNotEmpty(((String)sindicatos.get(3)))){
        		cell.setCellValue(((String)sindicatos.get(3)));
        	}
        	cell.setCellStyle(estiloFilaCentro(contador,excel));
        	
        	cell = row.createCell((short)5); 
        	cell2 = row.createCell((short)6); 
        	cell3 = row.createCell((short)7); 
        	sheet.addMergedRegion(new Region(this.j+this.contador,(short)5,this.j+this.contador,(short)7));//NOPMD
        	if(StringUtils.isNotEmpty(((String)sindicatos.get(4)))){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((String)sindicatos.get(4))));
        	}
        	cell.setCellStyle(estiloFila(contador,excel));
        	cell2.setCellStyle(estiloFila(contador,excel));
        	cell3.setCellStyle(estiloFila(contador,excel));
        	
        	cell = row.createCell((short)8); 
        	if(StringUtils.isNotEmpty(((String)sindicatos.get(5)))){
        		cell.setCellValue(W83bUtilidades.numero(((String)sindicatos.get(5))));
        	}
        	cell.setCellStyle(estiloFilaCentro(contador,excel));
        	
        	cell = row.createCell((short)9);
        
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(6))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(6)))));
        	}
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)10);
        	
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(9))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(9)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)11);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(8))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(8)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)12);
        	cell2 = row.createCell((short)13);
        	sheet.addMergedRegion(new Region(j+contador,(short)12,j+contador,(short)13));//NOPMD
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(7))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(7)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell2.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)14);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(10))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(10)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)15);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(11))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(11)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)16);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(12))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(12)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)17);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(13))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(13)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)18);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(14))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(14)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)19);
        	if (!"".equals(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(15))))){
        		cell.setCellValue(W83bUtilidades.numero(W83bUtilidadesExcel.blancoCampoExcel(((String)sindicatos.get(15)))));
        	}
        	
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	cell = row.createCell((short)20);
        	if (Integer.parseInt((String)sindicatos.get(6))+Integer.parseInt((String)sindicatos.get(7))+Integer.parseInt((String)sindicatos.get(8))+Integer.parseInt((String)sindicatos.get(9))+Integer.parseInt((String)sindicatos.get(10))+Integer.parseInt((String)sindicatos.get(11))+Integer.parseInt((String)sindicatos.get(12))+Integer.parseInt((String)sindicatos.get(13))+Integer.parseInt((String)sindicatos.get(14))+Integer.parseInt((String)sindicatos.get(15))==0){
        		cell.setCellValue("");
        	}
        	else{
        		cell.setCellValue(Integer.parseInt((String)sindicatos.get(6))+Integer.parseInt((String)sindicatos.get(7))+Integer.parseInt((String)sindicatos.get(8))+Integer.parseInt((String)sindicatos.get(9))+Integer.parseInt((String)sindicatos.get(10))+Integer.parseInt((String)sindicatos.get(11))+Integer.parseInt((String)sindicatos.get(12))+Integer.parseInt((String)sindicatos.get(13))+Integer.parseInt((String)sindicatos.get(14))+Integer.parseInt((String)sindicatos.get(15)));
        	}
        	cell.setCellStyle(estiloFilaNumero(contador,excel));
        	contador=contador+1;
        	i=i+1;
	}
        
	}
	
}

	
